<?php
header("Content-Type: application/json; charset=utf-8");

$ocrApiKey = "K88656468488957";
$url = "https://bdris.gov.bd/br/correction";

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
curl_setopt($ch, CURLOPT_HEADER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 10);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    "User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/122.0.0.0 Safari/537.36"
]);
$response = curl_exec($ch);
$headerSize = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
$header = substr($response, 0, $headerSize);
$body = substr($response, $headerSize);
preg_match_all('/Set-Cookie:\s*([^;]+)/i', $header, $matches);
$cookies = [];
foreach ($matches[1] as $cookie) {
    $parts = explode("=", $cookie, 2);
    if (count($parts) == 2) $cookies[trim($parts[0])] = trim($parts[1]);
}
curl_close($ch);

libxml_use_internal_errors(true);
$dom = new DOMDocument();
$dom->loadHTML($body);
$xpath = new DOMXPath($dom);
$img = $xpath->query("//img[@id='captcha']")->item(0) ?? $xpath->query("//img[@alt='captcha']")->item(0);

$captcha = "";
if ($img) {
    $src = $img->getAttribute("src");
    if (strpos($src, "base64,") !== false) {
        $base64 = explode("base64,", $src)[1];
        $ocr = curl_init();
        curl_setopt($ocr, CURLOPT_URL, "https://api.ocr.space/parse/image");
        curl_setopt($ocr, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ocr, CURLOPT_TIMEOUT, 10);
        curl_setopt($ocr, CURLOPT_POST, true);
        curl_setopt($ocr, CURLOPT_POSTFIELDS, [
            "apikey" => $ocrApiKey,
            "base64Image" => "data:image/png;base64," . $base64,
            "language" => "eng",
            "OCREngine" => 2
        ]);
        $result = json_decode(curl_exec($ocr), true);
        curl_close($ocr);
        if (isset($result["ParsedResults"][0]["ParsedText"])) {
            $captcha = trim($result["ParsedResults"][0]["ParsedText"]);
        }
    }
}

$cookieString = "";
foreach ($cookies as $key => $val) {
    $cookieString .= "$key=$val; ";
}
$cookieString = rtrim($cookieString, "; ");

$output = [
    "captchaAns" => $captcha,
    "Cookie" => $cookieString
];

file_put_contents("Bypass.json", json_encode($output, JSON_PRETTY_PRINT));
echo json_encode($output, JSON_PRETTY_PRINT);