<?php
$sessionSourceUrl = "https://" . $_SERVER['HTTP_HOST'] . "/Captcha.php";
$apiUrl = "https://bdris.gov.bd/api/br/search-by-ubrn-and-dob";
$userAgent = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36";

function makeRequest($url, $headers = []) {
    global $userAgent;
    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_SSL_VERIFYPEER => false,
        CURLOPT_SSL_VERIFYHOST => false,
        CURLOPT_USERAGENT => $userAgent,
        CURLOPT_HTTPHEADER => $headers,
    ]);
    $response = curl_exec($ch);
    curl_close($ch);
    return $response;
}

function getCaptchaFromBypass() {
    $path = __DIR__ . "/Bypass.json";
    if (!file_exists($path)) return null;
    $data = json_decode(file_get_contents($path), true);
    return [
        'captcha' => $data['captchaAns'] ?? '',
        'cookie' => $data['Cookie'] ?? ''
    ];
}

function getCaptchaFromPhp() {
    global $sessionSourceUrl;
    $response = makeRequest($sessionSourceUrl);
    $data = json_decode($response, true);
    return [
        'captcha' => $data['captchaAns'] ?? '',
        'cookie' => $data['Cookie'] ?? ''
    ];
}

function tryApiRequest($brn, $dob, $session) {
    global $apiUrl;

    $queryParams = http_build_query([
        'ubrn' => $brn,
        'personBirthDate' => date("d/m/Y", strtotime($dob)),
        'captchaAns' => $session['captcha']
    ]);

    $response = makeRequest("$apiUrl?$queryParams", ["Cookie: " . $session['cookie']]);
    $data = json_decode($response, true);

    if ($data && isset($data[0]['personNameBn'])) {
        return $data;
    }
    return null;
}

function submitRequest($brn, $dob) {
    if (!preg_match('/^\d{17}$/', $brn) || !preg_match('/^\d{4}-\d{2}-\d{2}$/', $dob)) {
        return;
    }

    $session = getCaptchaFromBypass();
    $data = tryApiRequest($brn, $dob, $session);

    if (!$data) {
        $session = getCaptchaFromPhp();
        $data = tryApiRequest($brn, $dob, $session);
    }

    if ($data) {
        $mappedData = array_map(function ($item) {
            $addressEnParts = explode(', ', $item['officeAddressEn']);
            $birthPlaceEn = '';
            foreach ($addressEnParts as $key => $part) {
                if (strpos($part, 'DIVISION') !== false && $key > 0) {
                    $birthPlaceEn = ucwords(strtolower($addressEnParts[$key - 1])) . ', Bangladesh';
                    break;
                }
            }

            $addressBnParts = explode(', ', $item['officeAddressBn']);
            $birthPlace = '';
            foreach ($addressBnParts as $key => $part) {
                if (strpos($part, 'বিভাগ') !== false && $key > 0) {
                    $birthPlace = $addressBnParts[$key - 1] . ', বাংলাদেশ';
                    break;
                }
            }

            $registerOfficeLocation = implode(', ', array_slice($addressBnParts, 1, 2));
            $registerOfficeLocationEn = ucwords(strtolower(implode(', ', array_slice($addressEnParts, 1, 2))));

            $result = [
                'Owner' => 'taka0nai',
                'nameBangla' => $item['personNameBn'],
                'nameEnglish' => $item['personNameEn'],
                'dateOfBirth' => $item['personDob'],
                'brn' => $item['ubrn'],
                'fatherName' => $item['fatherNameBn'],
                'fatherNameEn' => $item['fatherNameEn'],
                'fathersNationality' => '',
                'fathersNationalityEn' => '',
                'motherName' => $item['motherNameBn'],
                'motherNameEn' => $item['motherNameEn'],
                'mothersNationality' => '',
                'mothersNationalityEn' => '',
                'birthPlace' => $birthPlace,
                'birthPlaceEn' => $birthPlaceEn,
                'address' => $item['officeAddressBn'],
                'addressEn' => ucwords(strtolower($item['officeAddressEn'])),
                'registerOffice' => $item['registrationOfficeNameBn'],
                'registerOfficeEn' => ucwords(strtolower($item['registrationOfficeNameEn'])),
                'registerOfficeLocation' => $registerOfficeLocation,
                'registerOfficeLocationEn' => $registerOfficeLocationEn
            ];

            if (!$item['foreign']) {
                $result['fathersNationality'] = 'বাংলাদেশি';
                $result['fathersNationalityEn'] = 'Bangladeshi';
                $result['mothersNationality'] = 'বাংলাদেশি';
                $result['mothersNationalityEn'] = 'Bangladeshi';
            }

            return $result;
        }, $data);

        header("Content-Type: application/json; charset=UTF-8");
        echo json_encode($mappedData[0], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
    }
}

if (!empty($_GET['brn']) && !empty($_GET['dob'])) {
    submitRequest($_GET['brn'], $_GET['dob']);
}