<?php
function isValidDateFormat($dateString) {
    return preg_match("/^\d{4}-\d{2}-\d{2}$/", $dateString);
}

function numberToOrdinalWord($number) {
    $words = [
        'First', 'Second', 'Third', 'Fourth', 'Fifth', 'Sixth', 'Seventh', 'Eighth', 'Ninth', 'Tenth',
        'Eleventh', 'Twelfth', 'Thirteenth', 'Fourteenth', 'Fifteenth', 'Sixteenth', 'Seventeenth', 'Eighteenth', 'Nineteenth', 'Twentieth',
        'Twenty First', 'Twenty Second', 'Twenty Third', 'Twenty Fourth', 'Twenty Fifth', 'Twenty Sixth', 'Twenty Seventh', 'Twenty Eighth', 'Twenty Ninth', 'Thirtieth', 'Thirty First'
    ];
    return $words[$number - 1];
}

function convertYearToWords($number) {
    if ($number >= 2000) {
        $f = new NumberFormatter("en", NumberFormatter::SPELLOUT);
        $words = $f->format($number);
        return ucwords(str_replace('-', ' ', $words));
    } else {
        $shortYear = substr($number, -2);
        $f = new NumberFormatter("en", NumberFormatter::SPELLOUT);
        $words = $f->format($shortYear);
        return "Nineteen " . ucwords(str_replace('-', ' ', $words));
    }
}

function formatDateToWords($dateString) {
    $dateParts = explode('-', $dateString);
    $day = numberToOrdinalWord((int)$dateParts[2]);
    $monthName = DateTime::createFromFormat('Y-m-d', $dateString)->format('F');
    $year = convertYearToWords((int)$dateParts[0]);

    return $day . ' of ' . $monthName . ' ' . $year;
}

header('Content-Type: application/json');

if (!isset($_GET['dob']) || !isValidDateFormat($_GET['dob'])) {
    echo json_encode(['error' => 'Use yyyy-mm-dd.']);
    exit();
}

echo json_encode(['dateOfBirthEn' => formatDateToWords($_GET['dob'])]);
?>